function OnMsg.ClassesBuilt()
	local Presets = Presets.BuildMenuSubcategory.Default

	local menus = {"Power", "Dome Services", "Habitats", "Infrastructure", "Production", "Dome Spires", "Storages", "Life-Support"}
	local submenus = {"Power", "DomeServices", "HER", "Infrastructure", "Production", "DomeSpires", "Storages", "LifeSupport"}
	
	for i, menu in ipairs(menus) do
		local submenu = "RDM_" .. submenus[i]
		local idx = table.find(Presets, 'id', submenu) or false
		
		if not idx then
			PlaceObj('BuildMenuSubcategory', {
				build_pos = 0,
				category = menu,
				category_name = submenu,
				description = T(486976113585, "Buildings from mods created by Silva."),
				display_name = T(681793985519,"Additional buildings"),
				group = "Default",
				icon = CurrentModPath .. "UI/Icons/additional_buildings.png",
				id = submenu,
			})
		end
	end
end